package com.hero.ui.dialog;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import javax.swing.JLabel;
import javax.swing.JPanel;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.characteristics.Characteristic;
import com.hero.objects.characteristics.EnergyDefense;
import com.hero.objects.characteristics.PhysicalDefense;
import com.hero.objects.powers.CompoundPower;
import com.hero.objects.powers.DamageResistance;
import com.hero.objects.powers.FlashDefense;
import com.hero.objects.powers.ForceField;
import com.hero.objects.powers.ForceWall;
import com.hero.objects.powers.MentalDefense;
import com.hero.objects.powers.Power;
import com.hero.objects.powers.PowerDefense;
import com.hero.ui.widgets.LevelTF;
import com.hero.util.Constants;
import com.hero.util.Rounder;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class DamageResistanceDialog extends PowerDialog {

	private static final long serialVersionUID = -2432901203781594918L;

	private JLabel pdLbl;

	LevelTF pdLevelTF;

	private JLabel edLbl;

	LevelTF edLevelTF;

	private JLabel mdLbl;

	LevelTF mdLevelTF;

	private JLabel fdLbl;

	LevelTF fdLevelTF;

	private JLabel powdLbl;

	LevelTF powdLevelTF;

	int mdTotal = 0;

	int fdTotal = 0;

	int powDTotal = 0;

	int pdTotal = 0;

	int edTotal = 0;

	private JLabel pdTotalLbl;

	private JLabel edTotalLbl;

	private JLabel mdTotalLbl;

	private JLabel powDTotalLbl;

	private JLabel fdTotalLbl;

	public DamageResistanceDialog(DamageResistance pow, boolean isNew,
			boolean isPower) {
		super(pow, isNew, isPower);
		power = pow;
		init();
	}

	@Override
	protected JPanel getTopPanel() {
		JPanel panel = super.getTopPanel();
		GridBagConstraints gbc = new GridBagConstraints();
		gbc.gridx = 0;
		gbc.gridy = 10;
		gbc.weightx = 0;
		gbc.weighty = 0;
		gbc.gridwidth = 1;
		gbc.gridheight = 1;
		gbc.fill = GridBagConstraints.NONE;
		gbc.anchor = GridBagConstraints.EAST;
		gbc.insets = new Insets(2, 5, 5, 2);
		gbc.gridy = 70;
		panel.add(pdLbl, gbc);
		gbc.gridy++;
		panel.add(edLbl, gbc);
		gbc.gridy++;
		panel.add(mdLbl, gbc);
		gbc.gridy++;
		panel.add(fdLbl, gbc);
		gbc.gridy++;
		panel.add(powdLbl, gbc);
		gbc.gridx = 1;
		gbc.anchor = GridBagConstraints.WEST;
		panel.add(powdLevelTF, gbc);
		gbc.gridy--;
		panel.add(fdLevelTF, gbc);
		gbc.gridy--;
		panel.add(mdLevelTF, gbc);
		gbc.gridy--;
		panel.add(edLevelTF, gbc);
		gbc.gridy--;
		panel.add(pdLevelTF, gbc);
		gbc.gridx = 2;
		gbc.weightx = 1;
		panel.add(pdTotalLbl, gbc);
		gbc.gridy++;
		panel.add(edTotalLbl, gbc);
		gbc.gridy++;
		panel.add(mdTotalLbl, gbc);
		gbc.gridy++;
		panel.add(fdTotalLbl, gbc);
		gbc.gridy++;
		panel.add(powDTotalLbl, gbc);

		return panel;
	}

	@Override
	protected void initListeners() {
		super.initListeners();
		pdLevelTF.addPropertyChangeListener("Level",
				new PropertyChangeListener() {
					public void propertyChange(PropertyChangeEvent e) {
						((DamageResistance) power).setPdLevels(pdLevelTF
								.getCurrent());
						updateValues();
					}
				});
		edLevelTF.addPropertyChangeListener("Level",
				new PropertyChangeListener() {
					public void propertyChange(PropertyChangeEvent e) {
						((DamageResistance) power).setEdLevels(edLevelTF
								.getCurrent());
						updateValues();
					}
				});
		mdLevelTF.addPropertyChangeListener("Level",
				new PropertyChangeListener() {
					public void propertyChange(PropertyChangeEvent e) {
						((DamageResistance) power).setMdLevels(mdLevelTF
								.getCurrent());
						updateValues();
					}
				});
		fdLevelTF.addPropertyChangeListener("Level",
				new PropertyChangeListener() {
					public void propertyChange(PropertyChangeEvent e) {
						((DamageResistance) power).setFdLevels(fdLevelTF
								.getCurrent());
						updateValues();
					}
				});
		powdLevelTF.addPropertyChangeListener("Level",
				new PropertyChangeListener() {
					public void propertyChange(PropertyChangeEvent e) {
						((DamageResistance) power).setPowdLevels(powdLevelTF
								.getCurrent());
						updateValues();
					}
				});
	}

	@Override
	protected void initWidgets() {
		super.initWidgets();

		Characteristic pd = HeroDesigner.getActiveHero().getCharacteristic(
				Constants.PD);
		if (pd != null) {
			int non = ((PhysicalDefense) pd).getNonresistantTotal(false);
			int res = ((PhysicalDefense) pd).getResistantTotal(false);
			pdTotal = non - res;
			if (!isNew) {
				if (((DamageResistance) power).getPdLevels() < res) {
					pdTotal += ((DamageResistance) power).getPdLevels();
				} else {
					pdTotal += res;
				}
			}
		}

		Characteristic ed = HeroDesigner.getActiveHero().getCharacteristic(
				Constants.ED);
		if (ed != null) {
			int non = ((EnergyDefense) ed).getNonresistantTotal(false);
			int res = ((EnergyDefense) ed).getResistantTotal(false);
			edTotal = non - res;
			if (!isNew) {
				if (((DamageResistance) power).getEdLevels() < res) {
					edTotal += ((DamageResistance) power).getEdLevels();
				} else {
					edTotal += res;
				}
			}
		}

		boolean addEgo = false;
		for (int i = 0; i < HeroDesigner.getActiveHero().getPowers().size(); i++) {
			if ((HeroDesigner.getActiveHero().getPowers().get(i) instanceof Power)
					&& !(HeroDesigner.getActiveHero().getPowers().get(i) instanceof DamageResistance)
					&& !(HeroDesigner.getActiveHero().getPowers().get(i) instanceof ForceWall)) {
				Power def = (Power) HeroDesigner.getActiveHero().getPowers()
						.get(i);
				mdTotal += def.getMdLevels();
				if (def instanceof MentalDefense) {
					addEgo = true;
				}
			}
		}
		for (int i = 0; i < HeroDesigner.getActiveHero().getEquipment().size(); i++) {
			if ((HeroDesigner.getActiveHero().getEquipment().get(i) instanceof Power)
					&& !(HeroDesigner.getActiveHero().getEquipment().get(i) instanceof DamageResistance)
					&& !(HeroDesigner.getActiveHero().getEquipment().get(i) instanceof ForceWall)) {
				Power def = (Power) HeroDesigner.getActiveHero().getEquipment()
						.get(i);
				mdTotal += def.getMdLevels();
				if (def instanceof MentalDefense) {
					addEgo = true;
				}
			}
		}
		Characteristic ego = HeroDesigner.getActiveHero().getCharacteristic(
				Constants.EGO);
		if ((ego != null) && (mdTotal > 0) && addEgo) {
			mdTotal = mdTotal
					+ (int) Rounder.roundHalfUp(ego.getSecondaryValue() / 5d);
		}

		for (int i = 0; i < HeroDesigner.getActiveHero().getPowers().size(); i++) {
			if (HeroDesigner.getActiveHero().getPowers().get(i) instanceof FlashDefense) {
				FlashDefense fd = (FlashDefense) HeroDesigner.getActiveHero()
						.getPowers().get(i);
				fdTotal += fd.getLevels();
			} else if (HeroDesigner.getActiveHero().getPowers().get(i) instanceof ForceField) {
				ForceField ff = (ForceField) HeroDesigner.getActiveHero()
						.getPowers().get(i);
				for (int k = 0; k < ff.getAssignedAdders().size(); k++) {
					Adder ad = ff.getAssignedAdders().get(k);
					if (ad.getXMLID().equals("FLASHDEFENSE")) {
						fdTotal += ad.getLevels();
					}
				}
			} else if (HeroDesigner.getActiveHero().getPowers().get(i) instanceof ForceWall) {
				ForceWall ff = (ForceWall) HeroDesigner.getActiveHero()
						.getPowers().get(i);
				for (int k = 0; k < ff.getAssignedAdders().size(); k++) {
					Adder ad = ff.getAssignedAdders().get(k);
					if (ad.getXMLID().equals("FLASHDEFENSE")) {
						fdTotal += ad.getLevels();
					}
				}
			} else if (HeroDesigner.getActiveHero().getPowers().get(i) instanceof CompoundPower) {
				CompoundPower cp = (CompoundPower) HeroDesigner.getActiveHero()
						.getPowers().get(i);
				for (int j = 0; j < cp.getPowers().size(); j++) {
					if (cp.getPowers().get(j) instanceof FlashDefense) {
						FlashDefense fd = (FlashDefense) cp.getPowers().get(j);
						fdTotal += fd.getLevels();
					} else if (cp.getPowers().get(j) instanceof ForceField) {
						ForceField ff = (ForceField) cp.getPowers().get(j);
						for (int k = 0; k < ff.getAssignedAdders().size(); k++) {
							Adder ad = ff.getAssignedAdders().get(k);
							if (ad.getXMLID().equals("FLASHDEFENSE")) {
								fdTotal += ad.getLevels();
							}
						}
					} else if (cp.getPowers().get(j) instanceof ForceWall) {
						ForceWall ff = (ForceWall) cp.getPowers().get(j);
						for (int k = 0; k < ff.getAssignedAdders().size(); k++) {
							Adder ad = ff.getAssignedAdders().get(k);
							if (ad.getXMLID().equals("FLASHDEFENSE")) {
								fdTotal += ad.getLevels();
							}
						}
					}
				}
			}
		}
		for (int i = 0; i < HeroDesigner.getActiveHero().getEquipment().size(); i++) {
			if (HeroDesigner.getActiveHero().getEquipment().get(i) instanceof FlashDefense) {
				FlashDefense fd = (FlashDefense) HeroDesigner.getActiveHero()
						.getEquipment().get(i);
				fdTotal += fd.getLevels();
			} else if (HeroDesigner.getActiveHero().getEquipment().get(i) instanceof ForceField) {
				ForceField ff = (ForceField) HeroDesigner.getActiveHero()
						.getEquipment().get(i);
				for (int k = 0; k < ff.getAssignedAdders().size(); k++) {
					Adder ad = ff.getAssignedAdders().get(k);
					if (ad.getXMLID().equals("FLASHDEFENSE")) {
						fdTotal += ad.getLevels();
					}
				}
			} else if (HeroDesigner.getActiveHero().getEquipment().get(i) instanceof ForceWall) {
				ForceWall ff = (ForceWall) HeroDesigner.getActiveHero()
						.getEquipment().get(i);
				for (int k = 0; k < ff.getAssignedAdders().size(); k++) {
					Adder ad = ff.getAssignedAdders().get(k);
					if (ad.getXMLID().equals("FLASHDEFENSE")) {
						fdTotal += ad.getLevels();
					}
				}
			} else if (HeroDesigner.getActiveHero().getEquipment().get(i) instanceof CompoundPower) {
				CompoundPower cp = (CompoundPower) HeroDesigner.getActiveHero()
						.getEquipment().get(i);
				for (int j = 0; j < cp.getPowers().size(); j++) {
					if (cp.getPowers().get(j) instanceof FlashDefense) {
						FlashDefense fd = (FlashDefense) cp.getPowers().get(j);
						fdTotal += fd.getLevels();
					} else if (cp.getPowers().get(j) instanceof ForceField) {
						ForceField ff = (ForceField) cp.getPowers().get(j);
						for (int k = 0; k < ff.getAssignedAdders().size(); k++) {
							Adder ad = ff.getAssignedAdders().get(k);
							if (ad.getXMLID().equals("FLASHDEFENSE")) {
								fdTotal += ad.getLevels();
							}
						}
					} else if (cp.getPowers().get(j) instanceof ForceWall) {
						ForceWall ff = (ForceWall) cp.getPowers().get(j);
						for (int k = 0; k < ff.getAssignedAdders().size(); k++) {
							Adder ad = ff.getAssignedAdders().get(k);
							if (ad.getXMLID().equals("FLASHDEFENSE")) {
								fdTotal += ad.getLevels();
							}
						}
					}
				}
			}
		}

		for (int i = 0; i < HeroDesigner.getActiveHero().getPowers().size(); i++) {
			if (HeroDesigner.getActiveHero().getPowers().get(i) instanceof PowerDefense) {
				PowerDefense def = (PowerDefense) HeroDesigner.getActiveHero()
						.getPowers().get(i);
				powDTotal += def.getLevels();
			} else if (HeroDesigner.getActiveHero().getPowers().get(i) instanceof ForceField) {
				ForceField ff = (ForceField) HeroDesigner.getActiveHero()
						.getPowers().get(i);
				powDTotal += ff.getPowdLevels();
			} else if (HeroDesigner.getActiveHero().getPowers().get(i) instanceof CompoundPower) {
				CompoundPower cp = (CompoundPower) HeroDesigner.getActiveHero()
						.getPowers().get(i);
				for (int j = 0; j < cp.getPowers().size(); j++) {
					if (cp.getPowers().get(j) instanceof PowerDefense) {
						PowerDefense def = (PowerDefense) cp.getPowers().get(j);
						powDTotal += def.getLevels();
					} else if (cp.getPowers().get(j) instanceof ForceField) {
						ForceField ff = (ForceField) cp.getPowers().get(j);
						powDTotal += ff.getPowdLevels();
					}
				}
			}
		}
		for (int i = 0; i < HeroDesigner.getActiveHero().getEquipment().size(); i++) {
			if (HeroDesigner.getActiveHero().getEquipment().get(i) instanceof PowerDefense) {
				PowerDefense def = (PowerDefense) HeroDesigner.getActiveHero()
						.getEquipment().get(i);
				powDTotal += def.getLevels();
			} else if (HeroDesigner.getActiveHero().getEquipment().get(i) instanceof ForceField) {
				ForceField ff = (ForceField) HeroDesigner.getActiveHero()
						.getEquipment().get(i);
				powDTotal += ff.getPowdLevels();
			} else if (HeroDesigner.getActiveHero().getEquipment().get(i) instanceof CompoundPower) {
				CompoundPower cp = (CompoundPower) HeroDesigner.getActiveHero()
						.getEquipment().get(i);
				for (int j = 0; j < cp.getPowers().size(); j++) {
					if (cp.getPowers().get(j) instanceof PowerDefense) {
						PowerDefense def = (PowerDefense) cp.getPowers().get(j);
						powDTotal += def.getLevels();
					} else if (cp.getPowers().get(j) instanceof ForceField) {
						ForceField ff = (ForceField) cp.getPowers().get(j);
						powDTotal += ff.getPowdLevels();
					}
				}
			}
		}

		levelTF.setVisible(false);
		damageLbl.setVisible(false);
		levelsLbl.setVisible(false);
		pdLbl = new JLabel("PD:");
		edLbl = new JLabel("ED:");
		mdLbl = new JLabel("Mental Def.:");
		fdLbl = new JLabel("Flash Def.:");
		powdLbl = new JLabel("Power Def.:");
		pdLevelTF = new LevelTF(((DamageResistance) power).getPdLevels(), 999,
				0);
		edLevelTF = new LevelTF(((DamageResistance) power).getEdLevels(), 999,
				0);
		mdLevelTF = new LevelTF(((DamageResistance) power).getMdLevels(), 999,
				0);
		fdLevelTF = new LevelTF(((DamageResistance) power).getFdLevels(), 999,
				0);
		powdLevelTF = new LevelTF(((DamageResistance) power).getPowdLevels(),
				999, 0);

		pdTotalLbl = new JLabel("(" + pdTotal + " total non-Resistant PD)");
		edTotalLbl = new JLabel("(" + edTotal + " total non-Resistant ED)");
		mdTotalLbl = new JLabel("(" + mdTotal + " total Mental Def.)");
		powDTotalLbl = new JLabel("(" + powDTotal + " total Power Def.)");
		fdTotalLbl = new JLabel("(" + fdTotal + " total Flash Def.)");
	}

	@Override
	public void updateValues() {
		super.updateValues();
		DamageResistance pow = (DamageResistance) power;
		if (pow.getPdLevels() > pdTotal) {
			pdTotalLbl.setForeground(Color.red);
		} else {
			pdTotalLbl.setForeground(Color.black);
		}
		if (pow.getEdLevels() > edTotal) {
			edTotalLbl.setForeground(Color.red);
		} else {
			edTotalLbl.setForeground(Color.black);
		}
		if (pow.getMdLevels() > mdTotal) {
			mdTotalLbl.setForeground(Color.red);
		} else {
			mdTotalLbl.setForeground(Color.black);
		}
		if (pow.getPowdLevels() > powDTotal) {
			powDTotalLbl.setForeground(Color.red);
		} else {
			powDTotalLbl.setForeground(Color.black);
		}
		if (pow.getFdLevels() > fdTotal) {
			fdTotalLbl.setForeground(Color.red);
		} else {
			fdTotalLbl.setForeground(Color.black);
		}
	}
}